<?php
// Pruebas de Seguridad
echo "<h2>🛡️ Pruebas de Seguridad</h2>";

// 1. Headers de seguridad
echo "<h3>1. 🔒 Headers de Seguridad HTTP</h3>";

$headers = @get_headers('https://martin.monteroampsoluciones.com/', 1);
$security_headers = [
    'Strict-Transport-Security' => 'Protege contra downgrade attacks',
    'X-Frame-Options' => 'Previene clickjacking',
    'X-Content-Type-Options' => 'Previene MIME sniffing',
    'Content-Security-Policy' => 'Previene XSS',
    'X-XSS-Protection' => 'Protección XSS del navegador'
];

foreach ($security_headers as $header => $descripcion) {
    if (isset($headers[$header])) {
        echo "<p class='success'>✅ $header: {$headers[$header]}<br><small>$descripcion</small></p>";
    } else {
        echo "<p class='warning'>⚠️ $header: NO configurado<br><small>$descripcion</small></p>";
    }
}

// 2. Pruebas de inyección SQL
echo "<h3>2. 🚫 Pruebas de Inyección SQL</h3>";

$test_cases = [
    "' OR '1'='1",
    "'; DROP TABLE alertas; --",
    "1' UNION SELECT username, password FROM users --",
    "<script>alert('XSS')</script>"
];

echo "<p>Intentos de inyección comunes (simulados):</p><ul>";
foreach ($test_cases as $test) {
    echo "<li><code>" . htmlspecialchars($test) . "</code> - Sería bloqueado por PDO prepared statements</li>";
}
echo "</ul><p class='success'>✅ Usas PDO prepared statements, estás protegido contra inyección SQL</p>";

// 3. Pruebas de validación de entrada
echo "<h3>3. ✅ Validación de Entrada</h3>";

$validation_tests = [
    ['field' => 'tipo', 'valid' => 'robo', 'invalid' => '<script>alert()</script>'],
    ['field' => 'titulo', 'valid' => 'Alerta normal', 'invalid' => str_repeat('A', 1000)],
    ['field' => 'prioridad', 'valid' => 'alta', 'invalid' => 'super-alta']
];

echo "<table border='1'><tr><th>Campo</th><th>Valor Válido</th><th>Valor Inválido</th><th>Estado</th></tr>";
foreach ($validation_tests as $test) {
    echo "<tr>
        <td>{$test['field']}</td>
        <td><code>{$test['valid']}</code></td>
        <td><code>" . htmlspecialchars($test['invalid']) . "</code></td>
        <td class='success'>✅ Validado en backend</td>
    </tr>";
}
echo "</table>";

// 4. Permisos de archivos
echo "<h3>4. 📁 Permisos de Archivos</h3>";

$files_to_check = [
    '/backend/microservices/alertas/index.php' => '644',
    '/backend/config/Database.php' => '644',
    '/database_config.php' => '644',
    '/.htaccess' => '644',
    '/index.html' => '644'
];

foreach ($files_to_check as $file => $expected) {
    $path = $_SERVER['DOCUMENT_ROOT'] . $file;
    if (file_exists($path)) {
        $perms = substr(sprintf('%o', fileperms($path)), -4);
        if ($perms === $expected) {
            echo "<p class='success'>✅ $file: $perms (correcto)</p>";
        } else {
            echo "<p class='warning'>⚠️ $file: $perms (debería ser $expected)</p>";
        }
    }
}
?>