<?php
// Pruebas específicas de Base de Datos
echo "<h2>🧪 Pruebas de Base de Datos</h2>";

try {
    $conn = new PDO("mysql:host=localhost;dbname=monteroa_alerta_ves", 
                   "monteroa_alerta_ves", 
                   "AlertaVES2025!");
    
    // 1. Prueba de rendimiento
    echo "<h3>1. ⚡ Rendimiento de Consultas</h3>";
    
    $start = microtime(true);
    $stmt = $conn->query("SELECT * FROM alertas ORDER BY fecha_creacion DESC LIMIT 100");
    $alertas = $stmt->fetchAll();
    $time = microtime(true) - $start;
    
    echo "<p>Tiempo consulta 100 alertas: " . round($time * 1000, 2) . " ms</p>";
    
    if ($time < 0.1) {
        echo "<p class='success'>✅ Excelente rendimiento</p>";
    } elseif ($time < 0.5) {
        echo "<p class='warning'>⚠️ Rendimiento aceptable</p>";
    } else {
        echo "<p class='error'>❌ Rendimiento lento, considerar índices</p>";
    }
    
    // 2. Verificar índices
    echo "<h3>2. 📊 Índices de la Tabla</h3>";
    $stmt = $conn->query("SHOW INDEX FROM alertas");
    $indices = $stmt->fetchAll();
    
    if (count($indices) > 1) {
        echo "<p class='success'>✅ Tabla tiene índices</p>";
        echo "<table border='1'><tr><th>Índice</th><th>Columna</th><th>Tipo</th></tr>";
        foreach ($indices as $indice) {
            echo "<tr><td>{$indice['Key_name']}</td><td>{$indice['Column_name']}</td><td>{$indice['Index_type']}</td></tr>";
        }
        echo "</table>";
    } else {
        echo "<p class='warning'>⚠️ Considera añadir índices para mejorar rendimiento</p>";
        echo "<pre>ALTER TABLE alertas ADD INDEX idx_fecha (fecha_creacion);
ALTER TABLE alertas ADD INDEX idx_prioridad (prioridad);
ALTER TABLE alertas ADD INDEX idx_tipo (tipo);</pre>";
    }
    
    // 3. Estadísticas
    echo "<h3>3. 📈 Estadísticas de Datos</h3>";
    
    $stats = $conn->query("SELECT 
        COUNT(*) as total,
        COUNT(DISTINCT tipo) as tipos_distintos,
        MIN(fecha_creacion) as mas_antigua,
        MAX(fecha_creacion) as mas_reciente,
        AVG(LENGTH(descripcion)) as prom_descripcion
    FROM alertas")->fetch();
    
    echo "<table border='1'>
        <tr><td><strong>Total alertas:</strong></td><td>{$stats['total']}</td></tr>
        <tr><td><strong>Tipos distintos:</strong></td><td>{$stats['tipos_distintos']}</td></tr>
        <tr><td><strong>Más antigua:</strong></td><td>{$stats['mas_antigua']}</td></tr>
        <tr><td><strong>Más reciente:</strong></td><td>{$stats['mas_reciente']}</td></tr>
    </table>";
    
    // 4. Distribución por tipo
    echo "<h3>4. 📋 Distribución por Tipo</h3>";
    $tipos = $conn->query("SELECT tipo, COUNT(*) as cantidad FROM alertas GROUP BY tipo ORDER BY cantidad DESC")->fetchAll();
    
    echo "<table border='1'><tr><th>Tipo</th><th>Cantidad</th><th>Porcentaje</th></tr>";
    foreach ($tipos as $tipo) {
        $porcentaje = round(($tipo['cantidad'] / $stats['total']) * 100, 1);
        echo "<tr><td>{$tipo['tipo']}</td><td>{$tipo['cantidad']}</td><td>{$porcentaje}%</td></tr>";
    }
    echo "</table>";
    
} catch (PDOException $e) {
    echo "<p class='error'>❌ Error BD: " . $e->getMessage() . "</p>";
}
?>