<?php
// ARCHIVO DE DIAGNÓSTICO - test.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

echo "<h3>🔍 DIAGNÓSTICO API ALERTA VES</h3>";

// 1. Test PHP
echo "<p>✅ PHP Version: " . phpversion() . "</p>";

// 2. Test PDO MySQL
try {
    $host = 'localhost';
    $dbname = 'monteroa_alerta_ves';
    $user = 'monteroa_alerta_ves';
    $pass = 'AlertaVES2025!';
    
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    echo "<p>✅ Conexión a BD ALERTAS: OK</p>";
    
    // Test consulta
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "<p>✅ Tablas en BD: " . implode(", ", $tables) . "</p>";
    
} catch (PDOException $e) {
    echo "<p style='color:red;'>❌ Error BD Alertas: " . $e->getMessage() . "</p>";
}

// 3. Test BD Notificaciones
try {
    $host = 'localhost';
    $dbname = 'monteroa_notificaciones_ves';
    $user = 'monteroa_notificaciones_ves';
    $pass = 'AlertaVES2025!';
    
    $pdo2 = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    echo "<p>✅ Conexión a BD NOTIFICACIONES: OK</p>";
    
} catch (PDOException $e) {
    echo "<p style='color:red;'>❌ Error BD Notificaciones: " . $e->getMessage() . "</p>";
}

// 4. Test JSON encoding
$test_array = ['test' => 'OK', 'timestamp' => date('Y-m-d H:i:s')];
$json_test = json_encode($test_array, JSON_UNESCAPED_UNICODE);
echo "<p>✅ JSON Encoding: " . ($json_test ? "OK" : "FAILED") . "</p>";

// 5. Test de tu api.php actual
echo "<hr><h4>📁 Test api.php actual:</h4>";
$api_content = @file_get_contents(__DIR__ . '/api.php');
if ($api_content) {
    // Buscar errores comunes de sintaxis
    if (strpos($api_content, 'notificarViaWebSocket') !== false) {
        echo "<p style='color:orange;'>⚠️ api.php contiene función 'notificarViaWebSocket' (puede causar error)</p>";
    }
    
    // Verificar si hay comas o paréntesis sin cerrar
    $open_parenthesis = substr_count($api_content, '(');
    $close_parenthesis = substr_count($api_content, ')');
    if ($open_parenthesis !== $close_parenthesis) {
        echo "<p style='color:red;'>❌ ERROR: Paréntesis desbalanceados: Abiertos=$open_parenthesis, Cerrados=$close_parenthesis</p>";
    }
} else {
    echo "<p>❌ No se pudo leer api.php</p>";
}
?>