    // backend/microservices/websocket/server.php
    <?php
    // Servidor WebSocket simple para cPanel
    class WebSocketServer {
        private $clients = [];
        
        public function __construct($host = '0.0.0.0', $port = 8080) {
            $socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
            socket_set_option($socket, SOL_SOCKET, SO_REUSEADDR, 1);
            socket_bind($socket, $host, $port);
            socket_listen($socket);
            
            $this->clients[] = $socket;
            echo "WebSocket Server iniciado en ws://$host:$port\n";
            
            $this->run($socket);
        }
        
        private function run($socket) {
            while (true) {
                $changed = $this->clients;
                socket_select($changed, $null, $null, 0, 10);
                
                foreach ($changed as $changed_socket) {
                    if ($changed_socket == $socket) {
                        $client = socket_accept($socket);
                        $this->clients[] = $client;
                        $this->send($client, $this->encode("Bienvenido al servidor de alertas"));
                    } else {
                        $bytes = @socket_recv($changed_socket, $buf, 1024, 0);
                        
                        if ($bytes == 0) {
                            $index = array_search($changed_socket, $this->clients);
                            unset($this->clients[$index]);
                            socket_close($changed_socket);
                        } else {
                            $msg = $this->decode($buf);
                            $this->broadcast($msg, $changed_socket);
                        }
                    }
                }
            }
        }
        
        private function broadcast($msg, $sender) {
            foreach ($this->clients as $client) {
                if ($client != $sender) {
                    @socket_write($client, $this->encode($msg), strlen($this->encode($msg)));
                }
            }
        }
        
        public function sendNewAlert($alertaData) {
            foreach ($this->clients as $client) {
                @socket_write($client, $this->encode(json_encode([
                    'type' => 'new_alert',
                    'data' => $alertaData
                ])), strlen($this->encode(json_encode($alertaData))));
            }
        }
        
        private function encode($text) {
            $b1 = 0x80 | (0x1 & 0x0f);
            $length = strlen($text);
            
            if ($length <= 125) {
                $header = pack('CC', $b1, $length);
            } elseif ($length > 125 && $length < 65536) {
                $header = pack('CCn', $b1, 126, $length);
            } else {
                $header = pack('CCN', $b1, 127, $length);
            }
            
            return $header . $text;
        }
        
        private function decode($text) {
            $length = ord($text[1]) & 127;
            
            if ($length == 126) {
                $masks = substr($text, 4, 4);
                $data = substr($text, 8);
            } elseif ($length == 127) {
                $masks = substr($text, 10, 4);
                $data = substr($text, 14);
            } else {
                $masks = substr($text, 2, 4);
                $data = substr($text, 6);
            }
            
            $text = "";
            for ($i = 0; $i < strlen($data); ++$i) {
                $text .= $data[$i] ^ $masks[$i % 4];
            }
            
            return $text;
        }
    }
    
 
