<?php
header("Content-Type: application/json; charset=utf-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Habilitar errores para depuracin (quitar en produccin)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Manejar preflight requests de CORS
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

 $method = $_SERVER['REQUEST_METHOD'];

try {
    require_once 'config/database.php';
    require_once 'controllers/NotificacionController.php';
    
    $notificacionController = new NotificacionController();
    
    if ($method === 'GET') {
        $result = $notificacionController->getNotificaciones();
        echo json_encode($result);
    } elseif ($method === 'POST') {
        $data = json_decode(file_get_contents("php://input"));
        $result = $notificacionController->createNotificacion($data);
        echo json_encode($result);
    } else {
        http_response_code(405);
        echo json_encode(array("success" => false, "message" => "Mtodo no permitido"));
    }
    
} catch (PDOException $e) {
    error_log("Error PDO en ms-notificaciones: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Error de base de datos',
        'detalle' => $e->getMessage()
    ]);
} catch (Exception $e) {
    error_log("Error general en ms-notificaciones: " . $e->getMessage());
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>