<?php
// API ALERTA VES - SIN NOTIFICACIONES GLOBALES
// Ruta: /backend/api.php

// ================= CONFIGURACIÓN =================
error_reporting(0);
ini_set('display_errors', 0);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// ================= CONFIGURACI07N DE ZONA HORARIA =================
// Forzar zona horaria de Per (Lima) independientemente del servidor
if (function_exists('date_default_timezone_set')) {
    date_default_timezone_set('America/Lima');
}

// Tambin configurar para MySQL si es necesario
try {
    $db = conectarBDAlertas();
    if ($db) {
        $db->exec("SET time_zone = '-05:00'");
    }
} catch (Exception $e) {
    // Silenciar error, no es crtico
}

// ================= FUNCIONES BD =================
function conectarBDAlertas() {
    $host = 'localhost';
    $dbname = 'monteroa_alerta_ves';
    $user = 'monteroa_alerta_ves';
    $pass = 'AlertaVES2025!';
    
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch (PDOException $e) {
        error_log("Error BD Alertas: " . $e->getMessage());
        return null;
    }
}

function conectarBDNotificaciones() {
    $host = 'localhost';
    $dbname = 'monteroa_notificaciones_ves';
    $user = 'monteroa_notificaciones_ves';
    $pass = 'AlertaVES2025!';
    
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch (PDOException $e) {
        error_log("Error BD Notificaciones: " . $e->getMessage());
        return null;
    }
}

// ================= MANEJAR RUTAS =================
$method = $_SERVER['REQUEST_METHOD'];
$url = isset($_GET['url']) ? $_GET['url'] : '';

// RUTA 1: GET /alertas - Obtener todas las alertas
if ($method === 'GET' && $url === 'alertas') {
    $db = conectarBDAlertas();
    
    if (!$db) {
        echo json_encode([
            'success' => false,
            'message' => 'Error de conexión a BD'
        ]);
        exit;
    }
    
    try {
        $sql = "SELECT * FROM alertas ORDER BY fecha_creacion DESC LIMIT 20";
        $stmt = $db->query($sql);
        $alertas = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Formatear fechas
        foreach ($alertas as &$alerta) {
            $fecha = new DateTime($alerta['fecha_creacion']);
            $alerta['fecha_formateada'] = $fecha->format('d/m/Y H:i:s');
            
            // Tiempo relativo
            $ahora = new DateTime();
            $diff = $ahora->diff($fecha);
            
            if ($diff->d > 0) {
                $alerta['tiempo_relativo'] = "hace {$diff->d} día" . ($diff->d > 1 ? 's' : '');
            } elseif ($diff->h > 0) {
                $alerta['tiempo_relativo'] = "hace {$diff->h} hora" . ($diff->h > 1 ? 's' : '');
            } elseif ($diff->i > 0) {
                $alerta['tiempo_relativo'] = "hace {$diff->i} minuto" . ($diff->i > 1 ? 's' : '');
            } else {
                $alerta['tiempo_relativo'] = "ahora mismo";
            }
        }
        
        echo json_encode([
            'success' => true,
            'message' => 'Alertas obtenidas',
            'count' => count($alertas),
            'data' => $alertas,
            'timestamp' => date('Y-m-d H:i:s')
        ], JSON_UNESCAPED_UNICODE);
        
    } catch (Exception $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Error en consulta: ' . $e->getMessage()
        ]);
    }
    exit;
}

// RUTA 2: POST /alertas - Crear alerta (SOLO PARA EL USUARIO QUE LA CREA)
elseif ($method === 'POST' && $url === 'alertas') {
    // Leer datos
    $input = json_decode(file_get_contents('php://input'), true);
    if (!$input) {
        $input = $_POST;
    }
    
    if (empty($input)) {
        echo json_encode(['success' => false, 'message' => 'Sin datos']);
        exit;
    }
    
    $dbAlertas = conectarBDAlertas();
    if (!$dbAlertas) {
        echo json_encode(['success' => false, 'message' => 'Error BD Alertas']);
        exit;
    }
    
    try {
        $tipo = $input['tipo'] ?? 'otro';
        $esPanico = ($tipo === 'panico');
        
        if ($esPanico) {
            $titulo = ' BOTON DE PANICO ACTIVADO';
            $descripcion = 'Usuario activó el botón de pánico. ¡Asistencia inmediata requerida!';
            $prioridad = 'alta';
        } else {
            $titulo = htmlspecialchars($input['titulo'] ?? 'Alerta', ENT_QUOTES, 'UTF-8');
            $descripcion = htmlspecialchars($input['descripcion'] ?? '', ENT_QUOTES, 'UTF-8');
            $prioridad = in_array($input['prioridad'] ?? 'media', ['baja', 'media', 'alta']) ? 
                         $input['prioridad'] : 'media';
        }
        
        $ubicacion = htmlspecialchars($input['ubicacion'] ?? 'Ubicación no especificada', ENT_QUOTES, 'UTF-8');
        $latitud = isset($input['latitud']) ? floatval($input['latitud']) : null;
        $longitud = isset($input['longitud']) ? floatval($input['longitud']) : null;
        
        // Insertar en BD principal
        $sql = "INSERT INTO alertas (tipo, titulo, descripcion, ubicacion, latitud, longitud, prioridad, fecha_creacion) 
                VALUES (:tipo, :titulo, :descripcion, :ubicacion, :latitud, :longitud, :prioridad, NOW())";
        
        $stmt = $dbAlertas->prepare($sql);
        $stmt->execute([
            ':tipo' => $tipo,
            ':titulo' => $titulo,
            ':descripcion' => $descripcion,
            ':ubicacion' => $ubicacion,
            ':latitud' => $latitud,
            ':longitud' => $longitud,
            ':prioridad' => $prioridad
        ]);
        
        $idAlerta = $dbAlertas->lastInsertId();
        
        // Insertar en BD de notificaciones (para registro interno, no para broadcast)
        $dbNotif = conectarBDNotificaciones();
        $idNotificacion = null;
        
        if ($dbNotif) {
            $mensaje = "ALERTA #{$idAlerta} - Tipo: " . strtoupper($tipo) . " - Título: {$titulo}";
            
            $sqlNotif = "INSERT INTO notificaciones (tipo, destinatario, mensaje, estado, fecha_creacion) 
                         VALUES ('email', 'admin@alertaves.com', :mensaje, 'pendiente', NOW())";
            
            $stmtNotif = $dbNotif->prepare($sqlNotif);
            $stmtNotif->execute([':mensaje' => $mensaje]);
            $idNotificacion = $dbNotif->lastInsertId();
        }
        
        // Respuesta exitosa - SIN WEBSOCKET, SIN NOTIFICACIONES GLOBALES
        echo json_encode([
            'success' => true,
            'message' => $esPanico ? ' Alerta de pánico enviada!' : 'Alerta creada exitosamente',
            'id_alerta' => $idAlerta,
            'id_notificacion' => $idNotificacion,
            'tipo' => $tipo,
            'websocket' => false, // No se usan websockets
            'notificado_a_todos' => false, // NO se notifica a todos
            'solo_para_creador' => true, // Solo para quien creó la alerta
            'timestamp' => date('Y-m-d H:i:s'),
            'alerta_data' => [
                'id' => $idAlerta,
                'tipo' => $tipo,
                'titulo' => $titulo,
                'descripcion' => $descripcion,
                'ubicacion' => $ubicacion,
                'prioridad' => $prioridad,
                'fecha_creacion' => date('Y-m-d H:i:s')
            ]
        ], JSON_UNESCAPED_UNICODE);
        
    } catch (Exception $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Error: ' . $e->getMessage()
        ]);
    }
    exit;
}

// RUTA 3: GET /status - Estado del sistema
elseif ($method === 'GET' && $url === 'status') {
    echo json_encode([
        'success' => true,
        'message' => 'API funcionando correctamente',
        'version' => '1.0-simple',
        'time' => date('Y-m-d H:i:s'),
        'features' => [
            'alertas_panico' => true,
            'notificaciones_globales' => false, // Desactivado
            'solo_para_creador' => true
        ]
    ]);
    exit;
}

// RUTA NO ENCONTRADA
else {
    echo json_encode([
        'success' => false,
        'message' => 'Ruta no encontrada',
        'available' => [
            'GET /alertas', 
            'POST /alertas', 
            'GET /status'
        ]
    ]);
    exit;
}
?>