<?php

// Usuario y contraseña permitidos
$usuarioPermitido = 'ADMIN';
$contrasenaPermitida = '13031990';

// Validar autenticación HTTP básica
if (!isset($_SERVER['PHP_AUTH_USER']) || !isset($_SERVER['PHP_AUTH_PW']) ||
    $_SERVER['PHP_AUTH_USER'] !== $usuarioPermitido || $_SERVER['PHP_AUTH_PW'] !== $contrasenaPermitida) {
    
    header('WWW-Authenticate: Basic realm="Área Restringida"');
    header('HTTP/1.0 401 Unauthorized');
    echo "Acceso denegado. Se requiere autenticación.";
    exit;
}


// Conexion con PDO
include 'conexion/conexion.php';

// Búsqueda por número de teléfono
$telefonoBuscado = $_GET['telefono'] ?? '';
$sql = "SELECT * FROM registros";
$parametros = [];

if ($telefonoBuscado !== '') {
    $sql .= " WHERE telefono LIKE :telefono";
    $parametros[':telefono'] = "%$telefonoBuscado%";
    $sql .= " ORDER BY fecha_hora DESC"; // No limit si hay búsqueda
} else {
    $sql .= " ORDER BY fecha_hora DESC LIMIT 50"; // Solo los últimos 50 si no hay búsqueda
}

$stmt = $pdo->prepare($sql);
$stmt->execute($parametros);
$registros = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Listado de Clientes</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(135deg, #f0f4f8, #e4ebf5);
      padding-top: 40px;
      font-family: 'Segoe UI', sans-serif;
    }
    .container-fluid {
      max-width: 95%;
      background: #ffffff;
      padding: 30px;
      border-radius: 12px;
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    }
    h2 {
      font-weight: bold;
      margin-bottom: 20px;
      color: #333;
    }
    .form-control {
      border-radius: 8px;
      box-shadow: none;
    }
    .table {
      margin-top: 15px;
      font-size: 0.92em;
    }
    .table thead th {
      background-color: #343a40 !important;
      color: #fff;
      vertical-align: middle;
    }
    .table td, .table th {
      white-space: nowrap;
      vertical-align: middle;
    }
    .search-label {
      font-weight: 500;
      margin-bottom: 6px;
      display: block;
    }
    .small-col {
      font-size: 0.85em;
    }
  </style>
</head>
<body>
  <div class="container-fluid">
    <h2 class="text-center">📋 Consentimientos de Clientes</h2>

    <label for="buscarTelefono" class="search-label">Buscar por número de teléfono:</label>
    <input type="text" class="form-control mb-3" id="buscarTelefono" placeholder="6XXXXXXXX" value="<?= htmlspecialchars($telefonoBuscado) ?>">

    <div class="table-responsive">
      <table class="table table-bordered table-hover table-striped align-middle text-center">
        <thead>
          <tr>
            <th>👤 Nombre</th>
            <th>👥 Apellido</th>
            <th>📱 Teléfono</th>
            <th>📧 Email</th>
            <th>🌐 IP</th>
            <th>🌍 País</th>
            <th>🏙️ Región</th>
            <th>🏢 ISP</th>
            <th>🛡️ VPN</th>
            <th>✅ Cons.</th>
            <th>📢 Trat.</th>
            <th>🕒 Fecha</th>
          </tr>
        </thead>
        <tbody>
          <?php if (count($registros) > 0): ?>
            <?php foreach ($registros as $row): ?>
              <tr>
                <td><?= htmlspecialchars($row['nombre']) ?></td>
                <td><?= htmlspecialchars($row['apellido']) ?></td>
                <td><?= htmlspecialchars($row['telefono']) ?></td>
                <td><?= htmlspecialchars($row['correo']) ?></td>
                <td class="small-col"><?= htmlspecialchars($row['ip_usuario']) ?></td>
                <td><?= htmlspecialchars($row['pais']) ?></td>
                <td><?= htmlspecialchars($row['provincia']) ?></td>
                <td><?= htmlspecialchars($row['proveedor']) ?></td>
                <td><?= $row['vpn_detectado'] ? '✅' : '❌' ?></td> <!-- NUEVA COLUMNA -->
                <td><?= $row['acepta_datos'] ? '✅' : '❌' ?></td>
                <td><?= $row['acepta_comerciales'] ? '✅' : '❌' ?></td>
                <td><?= date('d/m/Y H:i', strtotime($row['fecha_hora'])) ?></td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="12" class="text-muted">No se encontraron registros.</td></tr>
          <?php endif; ?>
        </tbody>
    </div>
  </div>

<script>
  const inputBuscar = document.getElementById("buscarTelefono");
  inputBuscar.addEventListener("input", () => {
    const query = inputBuscar.value.trim();
    const url = new URL(window.location.href);
    if (query.length > 0) {
      url.searchParams.set("telefono", query);
    } else {
      url.searchParams.delete("telefono");
    }
    window.location.href = url.toString();
  });
</script>

</body>
</html>
