<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    // Redirige al formulario o muestra un mensaje
    header('Location: index.php'); // Cambia a la página del formulario
    exit;
}

date_default_timezone_set('Europe/Madrid');
require_once 'conexion/conexion.php';

// Obtener IP del usuario
function obtenerIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) return $_SERVER['HTTP_CLIENT_IP'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    return $_SERVER['REMOTE_ADDR'];
}

// Consultar geolocalización usando ip-api.com
function obtenerGeoIP($ip) {
    $url = "http://ip-api.com/json/{$ip}?fields=status,country,regionName,as,proxy,hosting";
    $response = @file_get_contents($url);
    if ($response === false) return ['Desconocido', 'Desconocido', 'Desconocido'];

    $data = json_decode($response, true);
    if (!isset($data['status']) || $data['status'] !== 'success') {
        return ['Desconocido', 'Desconocido', 'Desconocido'];
    }

    return [
        $data['country'] ?? 'Desconocido',
        $data['regionName'] ?? 'Desconocido',
        $data['as'] ?? 'Desconocido',
        $data['proxy'] ?? '0',
        $data['hosting'] ?? '0'
    ];
}

// Datos del formulario
$nombre         = $_POST['nombre'] ?? '';
$apellido       = $_POST['apellido'] ?? '';
$telefono       = $_POST['telefono'] ?? '';
$correo         = $_POST['correo'] ?? '';
$aceptaDatos    = isset($_POST['consentimiento']) ? 1 : 0;
$aceptaComercio = isset($_POST['comunicaciones']) ? 1 : 0;
$ipUsuario      = obtenerIP();
$fechaHora      = date('Y-m-d H:i:s');


// Obtener datos de geolocalización
[$pais, $provincia, $proveedor,$proxy,$hosting] = obtenerGeoIP($ipUsuario);
if ($proxy || $hosting) {
    $vpnDetectado = true;
} else {
    $vpnDetectado = false;
}

// Guardar en la base de datos
try {
    $stmt = $pdo->prepare("INSERT INTO registros 
        (nombre, apellido, telefono, correo, acepta_datos, acepta_comerciales, ip_usuario, pais, provincia, proveedor, fecha_hora,vpn_detectado) 
        VALUES (:nombre, :apellido, :telefono, :correo, :acepta_datos, :acepta_comerciales, :ip_usuario, :pais, :provincia, :proveedor, :fecha_hora, :vpn_detectado)");

    $stmt->execute([
        ':nombre'             => $nombre,
        ':apellido'           => $apellido,
        ':telefono'           => $telefono,
        ':correo'             => $correo,
        ':acepta_datos'       => $aceptaDatos,
        ':acepta_comerciales' => $aceptaComercio,
        ':ip_usuario'         => $ipUsuario,
        ':pais'               => $pais,
        ':provincia'          => $provincia,
        ':proveedor'          => $proveedor,
        ':fecha_hora'         => $fechaHora,
        ':vpn_detectado'       => $vpnDetectado
    ]);
    
    $_SESSION['formulario_enviado'] = true; 
    header("Location: gracias.php");
    exit;

} catch (PDOException $e) {
    echo "<p style='color:red;text-align:center;'>Error al guardar los datos: " . $e->getMessage() . "</p>";
}
?>
