<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Política de Privacidad - MONTERO AMP SOLUCIONES</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background-color: #f5f8fc;
      font-family: 'Segoe UI', sans-serif;
      line-height: 1.9;
    }
    header, footer {
      background-color: #002e5b;
      color: white;
      padding: 40px 0;
    }
    header img {
      max-height: 100px;
      margin-bottom: 20px;
      background-color: white;
      
    }
    header h1 {
      font-size: 2rem;
      margin: 0;
    }
    .content {
      background: white;
      padding: 60px;
      margin-top: 50px;
      margin-bottom: 60px;
      border-radius: 15px;
      box-shadow: 0 5px 25px rgba(0,0,0,0.08);
    }
    h2 {
      color: #002e5b;
      margin-top: 60px;
      padding-top: 30px;
      border-top: 1px solid #dee2e6;
      font-size: 1.7rem;
    }
    h3 {
      color: #003e7e;
      margin-top: 45px;
      font-size: 1.3rem;
    }
    ul {
      list-style-type: disc;
      padding-left: 30px;
      margin-top: 15px;
    }
    p {
      margin-bottom: 25px;
    }
    .bloque {
      margin-bottom: 70px;
    }
  </style>
</head>
<body>

<header class="text-center">
  <div class="container">
    <img src="img/montero.png" alt="Logo MONTERO AMP SOLUCIONES">
    <h1>Política de Privacidad - MONTERO AMP SOLUCIONES</h1>
  </div>
</header>

<div class="container content">

  <div class="bloque">
    <p><strong>MONTERO AMP SOLUCIONES</strong> reconoce la importancia de proteger los datos personales de sus clientes y usuarios. Esta política de privacidad detalla cómo recogemos, tratamos y protegemos tus datos conforme a la normativa vigente.</p>
  </div>

  <div class="bloque">
    <h2>1. Información al usuario</h2>

    <h3>¿Quién es el responsable del tratamiento de tus datos?</h3>
    <ul>
      <li><strong>Nombre comercial:</strong> MONTERO AMP SOLUCIONES</li>
      <li><strong>Razón social:</strong> MONTERO AMP SOLUCIONES</li>
      <li><strong>NIF:</strong> B-82896119</li>
      <li><strong>Domicilio:</strong> Avenida de las Cortes Valencianas, 58. Torre Empresarial Levante. Planta 7, Oficina 702. CP 46015 (Valencia)</li>
      <li><strong>Email:</strong> <a href="mailto:info@monteroampsoluciones.com">info@monteroampsoluciones.com</a></li>
    </ul>
  </div>

  <div class="bloque">
    <h3>¿Qué tipo de datos recogemos?</h3>
    <ul>
      <li>Datos identificativos proporcionados voluntariamente</li>
      <li>Datos sobre comunicaciones y formularios enviados</li>
      <li>Datos técnicos como dirección IP, cookies y logs de navegación</li>
      <li>Información derivada de relaciones contractuales o precontractuales</li>
    </ul>
  </div>

  <div class="bloque">
    <h3>¿Con qué finalidad tratamos tus datos?</h3>
    <ul>
      <li><strong>Atención al cliente:</strong> Para responder a tus consultas o peticiones.</li>
      <li><strong>Comunicaciones comerciales:</strong> Solo si has dado tu consentimiento expreso.</li>
      <li><strong>Mejoras técnicas:</strong> Para optimizar nuestros servicios y experiencia de usuario.</li>
    </ul>
  </div>

  <div class="bloque">
    <h3>Base legal para el tratamiento</h3>
    <ul>
      <li>Consentimiento explícito del usuario</li>
      <li>Cumplimiento de obligaciones contractuales</li>
      <li>Requisitos legales aplicables</li>
    </ul>
  </div>

  <div class="bloque">
    <h3>¿Durante cuánto tiempo conservamos tus datos?</h3>
    <p>Los datos personales se conservan únicamente durante el tiempo necesario para los fines específicos para los que fueron recopilados. Una vez cumplido el plazo, serán bloqueados y eliminados conforme a la normativa vigente.</p>
  </div>

  <div class="bloque">
    <h3>¿Se comparten tus datos con terceros?</h3>
    <p>No vendemos ni compartimos tus datos personales, salvo por obligaciones legales. Podemos colaborar con proveedores que acceden a tus datos bajo contratos de confidencialidad y solo para prestar servicios necesarios.</p>
  </div>

  <div class="bloque">
    <h3>¿Qué derechos tienes como usuario?</h3>
    <ul>
      <li>Acceder, rectificar o eliminar tus datos personales</li>
      <li>Solicitar la limitación u oposición al tratamiento</li>
      <li>Retirar tu consentimiento en cualquier momento</li>
      <li>Solicitar la portabilidad de tus datos</li>
      <li>Presentar una reclamación ante la Agencia Española de Protección de Datos (AEPD)</li>
    </ul>
  </div>

  <div class="bloque">
    <h3>¿Cómo puedes ejercer estos derechos?</h3>
    <p>Envíanos tu solicitud al correo electrónico <a href="mailto:info@monteroampsoluciones.com">info@monteroampsoluciones.com</a> o por carta a nuestra dirección postal. Es importante que incluyas una copia de tu DNI y la petición clara del derecho que deseas ejercer.</p>
  </div>

  <div class="bloque">
    <h2>2. Medidas de seguridad</h2>
    <p>En MONTERO AMP SOLUCIONES aplicamos estrictas medidas de seguridad técnicas y organizativas que garantizan la protección de tus datos personales frente a accesos no autorizados, pérdidas, alteraciones o divulgaciones indebidas, conforme a lo establecido en el RGPD y la LOPDGDD.</p>
  </div>

  <div class="bloque">
    <h3>Contacto para más información</h3>
    <p><strong>Email:</strong> <a href="mailto:info@monteroampsoluciones.com">info@monteroampsoluciones.com</a></p>
    <p><strong>Dirección:</strong> Avenida de las Cortes Valencianas, 58. Torre Empresarial Levante. Planta 7, Oficina 702. CP 46015 (Valencia)</p>
  </div>

</div>

<footer class="text-center">
  <div class="container">
    <p>&copy; <?= date('Y') ?> MONTERO AMP SOLUCIONES. Todos los derechos reservados.</p>
  </div>
</footer>

</body>
</html>
