<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Formulario</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    body {
      background: #dadbdbff;
    }
    .form-container {
      background-color: #ffffff;
      padding: 30px;
      border-radius: 15px;
      box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
      max-width: 600px;
      margin: auto;
    }
    .logo {
      max-width: 350px;
      display: block;
      margin: 0 auto 20px auto;
    }
    footer {
      margin-top: 40px;
      color: #6c757d;
    }
  </style>
</head>
<body>

<div class="container py-5">
  <div class="form-container">
    <!-- Logo -->
    <!-- <img src="https://via.placeholder.com/150x50?text=Synergy+Logo" alt="logo" class="logo"> -->
    <img src="img/montero.png" alt="logo" class="logo">

    <p class="text-center mb-4 text-secondary">
      Si estás interesado en recibir una oferta de telecomunicaciones o energía, rellena el formulario y nos pondremos en contacto contigo.
    </p>
    <p class="text-center text-muted">Los campos marcados con el símbolo asterisco (*) son obligatorios.</p>

    <!-- Formulario -->
    <form id="formulario" class="needs-validation" action="procesar.php" method="POST" novalidate>
      <div class="mb-3">
        <label for="nombre" class="form-label">Nombre *</label>
        <input type="text" class="form-control mayuscula" id="nombre" name="nombre" required>
        <div class="invalid-feedback">Por favor, ingresa tu nombre.</div>
      </div>

      <div class="mb-3">
        <label for="apellido" class="form-label">Apellido *</label>
        <input type="text" class="form-control mayuscula" id="apellido" name="apellido" required>
        <div class="invalid-feedback">Por favor, ingresa tu apellido.</div>
      </div>

      <div class="mb-3">
          <label for="telefono" class="form-label">Teléfono *</label>
          <input 
            type="tel" 
            class="form-control" 
            id="telefono" 
            name="telefono" 
            maxlength="9"
            required
            placeholder="6XXXXXXXX"
          >
          <div id="telefono-feedback" class="invalid-feedback">
            El teléfono debe tener 9 dígitos y comenzar con 6.
          </div>
      </div>

      <div class="mb-3">
        <label for="correo" class="form-label">Correo electrónico</label>
        <input type="email" class="form-control" id="correo" name="correo">
      </div>

      <div class="form-check mb-2">
        <input class="form-check-input" type="checkbox" id="consentimiento" name="consentimiento" required>
        <label class="form-check-label" for="consentimiento">
          Consiento el tratamiento de mis datos en los términos establecidos en la <a href="politicasdeprivacidad.php">política de privacidad de MONTERO AMP SOLUCIONES S.A.C</a> *
        </label>
        <div class="invalid-feedback">Debes aceptar el tratamiento de tus datos.</div>
      </div>

      <div class="form-check mb-4">
        <input class="form-check-input" type="checkbox" id="comunicaciones" name="comunicaciones">
        <label class="form-check-label" for="comunicaciones">
          Acepto recibir comunicaciones comerciales personalizadas por parte de MONTERO AMP SOLUCIONES S.A.C acorde a lo establecido en la <a href="politicasdeprivacidad.php">política de privacidad</a>.
        </label>
      </div>

      <div class="d-grid">
        <button type="submit" class="btn btn-primary">Enviar</button>
      </div>

      <div class="text-center mt-4">
        <img src="img/lowi.png" alt="Decorativa" style="max-width: 200px;">
      </div>
    </form>
  </div>

  <!-- Footer -->
  <footer class="text-center mt-5">
    <hr>
    <p>2018 - 2025 © MONTERO AMP SOLUCIONES S.A.C</p>
  </footer>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  // Validación Bootstrap
  (function () {
    'use strict'
    const forms = document.querySelectorAll('.needs-validation')
    Array.from(forms).forEach(function (form) {
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault()
          event.stopPropagation()
        }
        form.classList.add('was-validated')
      }, false)
    })
  })()
</script>

<script>
  const telefonoInput = document.getElementById('telefono');
  const telefonoFeedback = document.getElementById('telefono-feedback');
  const form = document.querySelector('form');

  // Validación en tiempo real
  telefonoInput.addEventListener('input', () => {
    // Eliminar todo lo que no sea dígito
    telefonoInput.value = telefonoInput.value.replace(/\D/g, '');

    const valor = telefonoInput.value;
    const esValido = /^6\d{8}$/.test(valor);

    if (valor.length === 9 && esValido) {
      telefonoInput.classList.add('is-valid');
      telefonoInput.classList.remove('is-invalid');
      telefonoFeedback.style.display = 'none';
    } else {
      telefonoInput.classList.remove('is-valid');
      telefonoInput.classList.add('is-invalid');
      telefonoFeedback.style.display = 'block';
    }
  });

  // Validación al enviar formulario
  form.addEventListener('submit', (event) => {
    const telefono = telefonoInput.value;
    const esValido = /^6\d{8}$/.test(telefono);

    if (!esValido) {
      telefonoInput.classList.add('is-invalid');
      telefonoFeedback.style.display = 'block';
      event.preventDefault();
      event.stopPropagation();
    }

    // Esta línea activa la validación visual de Bootstrap
    form.classList.add('was-validated');
  });
</script>


<script>
  document.querySelectorAll('.mayuscula').forEach(input => {
    input.style.textTransform = 'uppercase';
    input.addEventListener('input', function () {
      this.value = this.value.toUpperCase();
    });
  });
</script>

<script>
document.getElementById('formulario').addEventListener('submit', function (e) {
  // Primero, revisar si la validación del formulario pasa
  if (!this.checkValidity()) {
    // Si no es válido, deja que Bootstrap muestre errores
    this.classList.add('was-validated');
    return;
  }

  e.preventDefault(); // Prevenir envío temporalmente para verificar IP

  fetch('verificarip.php')
    .then(response => response.json())
    .then(data => {
      if (data.envios >= 10) {
        alert("No puedes enviar más solicitudes en este momento");
      } else {
        this.submit(); // Ahora sí, se puede enviar
      }
    })
    .catch(() => {
      alert("Error al verificar al enviar solicitud.");
    });
});
</script>

</body>
</html>
