<?php
session_start();

if (!isset($_SESSION['formulario_enviado']) || $_SESSION['formulario_enviado'] !== true) {
    // Acceso no autorizado: redirigir al inicio o formulario
    header("Location: index.php"); // O el archivo que desees
    exit;
}

// Si está autorizado, borra la variable para que no pueda reutilizarla
unset($_SESSION['formulario_enviado']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Gracias por contactarnos</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    body {
      background-color: #f8f9fa;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
      margin: 0;
    }
    .mensaje {
      text-align: center;
      max-width: 600px;
      background: #fff;
      padding: 40px;
      border-radius: 15px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    .mensaje img {
      max-width: 200px;
      margin-bottom: 20px;
    }
    .mensaje h2 {
      color: #007bff;
      margin-bottom: 15px;
    }
    .mensaje p {
      color: #555;
    }
  </style>
</head>
<body>
  <div class="mensaje">
    <img src="img/montero.png" alt="Logo Montero">
    <h2>¡Gracias por contactar con nosotros!</h2>
    <p>Nos pondremos en contacto con usted lo antes posible.</p>
  </div>
</body>
</html>
