/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.13-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: monteroa_ferreteria
-- ------------------------------------------------------
-- Server version	10.11.13-MariaDB-cll-lve

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `monteroa_ferreteria`
--


--
-- Table structure for table `categorias`
--

DROP TABLE IF EXISTS `categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `descripcion` text DEFAULT NULL,
  `fecha_creacion` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias`
--

LOCK TABLES `categorias` WRITE;
/*!40000 ALTER TABLE `categorias` DISABLE KEYS */;
INSERT INTO `categorias` (`id`, `nombre`, `descripcion`, `fecha_creacion`) VALUES (1,'Herramientas Manuales','Martillos, destornilladores, alicates, etc.','2025-12-14 19:03:06'),
(2,'Electricidad','Cables, interruptores, focos, etc.','2025-12-14 19:03:06'),
(3,'Fontanería','Tuberías, llaves, conectores, etc.','2025-12-14 19:03:06'),
(4,'Pintura','Pinturas, brochas, rodillos, etc.','2025-12-14 19:03:06'),
(5,'Fijación','Tornillos, clavos, anclajes, etc.','2025-12-14 19:03:06');
/*!40000 ALTER TABLE `categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contactos`
--

DROP TABLE IF EXISTS `contactos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contactos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `telefono` varchar(20) DEFAULT NULL,
  `asunto` varchar(200) NOT NULL,
  `mensaje` text NOT NULL,
  `tipo_consulta` varchar(50) DEFAULT NULL,
  `fecha_envio` timestamp NULL DEFAULT current_timestamp(),
  `leido` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contactos`
--

LOCK TABLES `contactos` WRITE;
/*!40000 ALTER TABLE `contactos` DISABLE KEYS */;
INSERT INTO `contactos` (`id`, `nombre`, `email`, `telefono`, `asunto`, `mensaje`, `tipo_consulta`, `fecha_envio`, `leido`) VALUES (1,'Martin','admin@ferreteria.com','123456789','Reporte','leeee','cotizacion','2025-12-15 12:48:31',0);
/*!40000 ALTER TABLE `contactos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `detalle_ventas`
--

DROP TABLE IF EXISTS `detalle_ventas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `detalle_ventas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_venta` int(11) NOT NULL,
  `id_producto` int(11) NOT NULL,
  `cantidad` int(11) NOT NULL,
  `precio_unitario` decimal(10,2) NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_venta` (`id_venta`),
  KEY `id_producto` (`id_producto`),
  CONSTRAINT `detalle_ventas_ibfk_1` FOREIGN KEY (`id_venta`) REFERENCES `ventas` (`id`),
  CONSTRAINT `detalle_ventas_ibfk_2` FOREIGN KEY (`id_producto`) REFERENCES `productos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `detalle_ventas`
--

LOCK TABLES `detalle_ventas` WRITE;
/*!40000 ALTER TABLE `detalle_ventas` DISABLE KEYS */;
INSERT INTO `detalle_ventas` (`id`, `id_venta`, `id_producto`, `cantidad`, `precio_unitario`, `subtotal`) VALUES (1,1,8,1,4.25,4.25),
(2,1,11,2,35.00,70.00),
(3,2,11,2,35.00,70.00),
(4,2,9,7,22.00,154.00),
(5,2,8,2,4.25,8.50),
(6,2,10,3,18.75,56.25),
(7,2,17,1,1.50,1.50),
(8,3,8,1,15.90,15.90),
(9,4,28,1,29.90,29.90),
(10,4,8,3,15.90,47.70),
(11,5,28,1,29.90,29.90),
(12,5,8,1,15.90,15.90),
(13,6,8,1,15.90,15.90),
(14,7,8,1,15.90,15.90),
(15,7,6,1,19.90,19.90),
(16,8,6,17,19.90,338.30),
(17,9,6,1,19.90,19.90),
(18,10,8,1,15.90,15.90),
(19,11,6,1,25.00,25.00),
(20,12,28,1,30.00,30.00),
(21,13,28,1,30.00,30.00);
/*!40000 ALTER TABLE `detalle_ventas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `movimientos_inventario`
--

DROP TABLE IF EXISTS `movimientos_inventario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `movimientos_inventario` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_producto` int(11) NOT NULL,
  `tipo` enum('entrada','salida','ajuste') NOT NULL,
  `cantidad` int(11) NOT NULL,
  `motivo` varchar(255) DEFAULT NULL,
  `id_usuario` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `id_producto` (`id_producto`),
  CONSTRAINT `movimientos_inventario_ibfk_1` FOREIGN KEY (`id_producto`) REFERENCES `productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `movimientos_inventario`
--

LOCK TABLES `movimientos_inventario` WRITE;
/*!40000 ALTER TABLE `movimientos_inventario` DISABLE KEYS */;
/*!40000 ALTER TABLE `movimientos_inventario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `productos`
--

DROP TABLE IF EXISTS `productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `productos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `descripcion` text DEFAULT NULL,
  `precio` decimal(10,2) NOT NULL DEFAULT 0.00,
  `stock` int(11) NOT NULL DEFAULT 0,
  `imagen` varchar(255) DEFAULT NULL,
  `fecha_creacion` timestamp NULL DEFAULT current_timestamp(),
  `stock_minimo` int(11) DEFAULT 5,
  `categoria` varchar(50) DEFAULT 'general',
  `id_categoria` int(11) DEFAULT NULL,
  `stock_reservado` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `fk_producto_categoria` (`id_categoria`),
  CONSTRAINT `fk_producto_categoria` FOREIGN KEY (`id_categoria`) REFERENCES `categorias` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `productos`
--

LOCK TABLES `productos` WRITE;
/*!40000 ALTER TABLE `productos` DISABLE KEYS */;
INSERT INTO `productos` (`id`, `nombre`, `descripcion`, `precio`, `stock`, `imagen`, `fecha_creacion`, `stock_minimo`, `categoria`, `id_categoria`, `stock_reservado`) VALUES (1,'Martillo de carpintero','Martillo con mango de madera y cabeza de acero forjado. Ideal para clavar y extraer clavos.',60.00,47,'martillo.png','2025-12-06 22:14:06',10,'herramientas',NULL,0),
(2,'Destornillador Phillips','Destornillador de punta Phillips con mango ergonómico. Tamaño mediano.',33.00,30,'61OFJLmDGoL._AC_UF894,1000_QL80_.jpg','2025-12-06 22:14:06',5,'herramientas',NULL,0),
(3,'Juego de llaves inglesas','Juego de 5 llaves inglesas de acero cromado, de: 6\", 8\", 10\".',50.00,20,'HADWK031.jpg','2025-12-06 22:14:06',5,'herramientas',NULL,0),
(4,'Taladro percutor','Taladro percutor inalámbrico 18V. Incluye batería y cargador.',400.00,15,'36820773-800-auto.webp','2025-12-06 22:14:06',3,'herramientas',NULL,0),
(5,'Sierra circular','Sierra circular de 7 1/4\" con disco de diamante. Potencia 1200W.',300.00,10,'productos3_5934-300x300.jpg','2025-12-06 22:14:06',2,'herramientas',NULL,0),
(6,'Clavos de acero 2\"','Caja de 100 clavos de acero galvanizado de 2 pulgadas.',25.00,179,'clavo-cemento-1-27-x-25mm-prodac-x-500-gr.jpg','2025-12-06 22:14:06',50,'ferreteria',NULL,0),
(7,'Tornillos madera 3\" x 50 Und.','Caja de 50 tornillos para madera de 3 pulgadas con cabeza hexagonal.',25.00,150,'images (3).jpg','2025-12-06 22:14:06',30,'ferreteria',NULL,0),
(8,'Bisagra de latón','Bisagra de latón de 3\" para puertas. Paquete de 2 unidades.',16.00,46,'D_NQ_NP_986981-MPE76374196791_052024-O.webp','2025-12-06 22:14:06',20,'ferreteria',NULL,0),
(9,'Cerradura de puerta','Cerradura de puerta con llave y pestillo. Incluye 3 llaves.',80.00,14,'images.jpg','2025-12-06 22:14:06',5,'ferreteria',NULL,0),
(10,'Alambre de acero','Rollo de alambre de acero galvanizado calibre 16. 50 metros.',50.00,4,'975747-a1.jpg','2025-12-06 22:14:06',10,'ferreteria',NULL,0),
(11,'Cable eléctrico 12 AWG','Cable eléctrico THHN calibre 12. Color negro. 100 metros.',90.00,18,'CABLE_CU_THWN_12_NG_ROLLO_ELECTROVERA.png','2025-12-06 22:14:06',10,'electricidad',NULL,0),
(12,'Tomacorriente','Tomacorriente estándar 125V 15A. Color blanco.',13.00,100,'images (2).jpg','2025-12-06 22:14:06',20,'electricidad',NULL,0),
(13,'Interruptor de luz','Interruptor de luz simple. Color blanco.',10.00,80,'w=1500,h=1500,fit=pad.webp','2025-12-06 22:14:06',15,'electricidad',NULL,0),
(14,'Cinta aislante','Rollo de cinta aislante eléctrica. Color negro. 19mm x 20m.',15.00,59,'CINTATemflex15518.png','2025-12-06 22:14:06',10,'electricidad',NULL,0),
(15,'Portalámpara','Portalámpara plástico con rosca E27. Para instalaciones interiores.',8.00,120,'portalamparas-con-arandela-e27-4a-250v.jpg','2025-12-06 22:14:06',30,'electricidad',NULL,0),
(16,'Tubo PVC 1/2','Tubo PVC de 1/2 pulgada. Longitud 3 metros.',23.00,50,'Slide12.jpg','2025-12-06 22:14:06',10,'fontanería',NULL,0),
(17,'Codo PVC 90°','Codo PVC de 90° para tubo de 1/2 pulgada.',6.00,99,'images (1).jpg','2025-12-06 22:14:06',20,'fontanería',NULL,0),
(18,'Válvula de paso','Válvula de paso de bronce de 1/2 pulgada.',40.00,30,'valvulacompuertabronce.webp','2025-12-06 22:14:06',5,'fontanería',NULL,0),
(19,'Flexómetro 5m','Flexómetro metálico de 5 metros con bloqueo automático.',40.00,40,'D_NQ_NP_872990-MLU73423366831_122023-O.webp','2025-12-06 22:14:06',10,'herramientas',NULL,0),
(20,'Nivel de burbuja','Nivel de burbuja de aluminio de 24\". Precisión 0.5mm/m.',50.00,25,'nivel burbuja.jpg','2025-12-06 22:14:06',5,'herramientas',NULL,0),
(21,'Llave stillson 10\"','Llave stillson de 10\" con dientes ajustables. Para tuberías.',90.00,15,'llave-stillson-10-15836-truper.webp','2025-12-06 22:14:06',3,'herramientas',NULL,0),
(22,'Soldadora de estaño','Soldadora de estaño eléctrica 40W con punta de cobre.',40.00,20,'1745868623065.jpg','2025-12-06 22:14:06',5,'electricidad',NULL,0),
(23,'Pistola de silicona','Pistola de calafatear para cartuchos de silicona. Metal.',30.00,35,'pistola-de-calafatear-para-cartuchos-silicona.png','2025-12-06 22:14:06',5,'ferreteria',NULL,0),
(24,'Cinta métrica x 10 m','Cinta métrica de fibra de 10 metros. Carcasa de plástico.',25.00,44,'wincha-flexometro-gripper-10-metros-contra-impacto-tpr-cinta-extra-ancha-carcasa-abs-fh-10m-14582-truper.webp','2025-12-06 22:14:06',10,'herramientas',NULL,0),
(25,'Escalera de aluminio','Escalera de aluminio plegable de 3 escalones. Capacidad 150kg.',130.00,10,'imageUrl_1.webp','2025-12-06 22:14:06',2,'herramientas',NULL,0),
(26,'Socket Plano E27 Blanco Pack x 3','Socket Plano Werken E27 Blanco Pack x 3:\r\nDiseño plano de alta calidad.\r\nFabricado en polipropileno y acero.\r\nTipo de rosca E27 y amperaje de 0.16666667 A.\r\nGarantía de 1 año para tu tranquilidad.\r\nIncluye tornillos para una instalación sencilla.',12.00,20,'null.webp','2025-12-12 01:36:31',20,'general',NULL,0),
(27,'Cuchillo Dyangrip retractable Stanley','Cuchilla con mango anti-deslizante aún con el uso de guantes, Cuenta con un mecanismo patentado de nariz superpuesta que mantiene la hoja segura en su posición. Incluye 3 hojas.',50.00,10,'10-779_1.jpg','2025-12-12 01:45:45',10,'general',NULL,0),
(28,'Alicate Pico de Loro 10\" ','Alicate Pico de Loro 10\" 17351 Truper',30.00,0,'X_pex-10x-e16265.jpg','2025-12-12 01:50:03',8,'general',NULL,0);
/*!40000 ALTER TABLE `productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `proveedores`
--

DROP TABLE IF EXISTS `proveedores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `proveedores` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `ruc` varchar(20) DEFAULT NULL,
  `telefono` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `direccion` text DEFAULT NULL,
  `activo` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `proveedores`
--

LOCK TABLES `proveedores` WRITE;
/*!40000 ALTER TABLE `proveedores` DISABLE KEYS */;
/*!40000 ALTER TABLE `proveedores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reclamos`
--

DROP TABLE IF EXISTS `reclamos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reclamos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo_reclamo` varchar(20) NOT NULL,
  `tipo_reclamo` enum('reclamo','queja','sugerencia') NOT NULL,
  `fecha_incidente` date NOT NULL,
  `fecha_registro` datetime DEFAULT current_timestamp(),
  `tipo_documento` enum('DNI','RUC','CE','Pasaporte') NOT NULL,
  `numero_documento` varchar(20) NOT NULL,
  `nombres_apellidos` varchar(200) NOT NULL,
  `domicilio` varchar(300) NOT NULL,
  `departamento` varchar(50) DEFAULT NULL,
  `provincia` varchar(50) DEFAULT NULL,
  `distrito` varchar(50) DEFAULT NULL,
  `telefono` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `descripcion_hechos` text NOT NULL,
  `pedido_reclamo` text NOT NULL,
  `monto_reclamado` decimal(10,2) DEFAULT 0.00,
  `tipo_bien` enum('producto','servicio','ambos') NOT NULL,
  `descripcion_bien` text DEFAULT NULL,
  `marca` varchar(100) DEFAULT NULL,
  `modelo` varchar(100) DEFAULT NULL,
  `numero_serie` varchar(100) DEFAULT NULL,
  `tipo_comprobante` enum('boleta','factura','ticket','ninguno') DEFAULT 'ninguno',
  `numero_comprobante` varchar(50) DEFAULT NULL,
  `fecha_compra` date DEFAULT NULL,
  `monto_compra` decimal(10,2) DEFAULT NULL,
  `estado` enum('registrado','en_revision','procesado','resuelto','archivado') DEFAULT 'registrado',
  `observaciones_internas` text DEFAULT NULL,
  `fecha_respuesta` date DEFAULT NULL,
  `respuesta_empresa` text DEFAULT NULL,
  `nombre_representante` varchar(200) DEFAULT NULL,
  `cargo_representante` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `codigo_reclamo` (`codigo_reclamo`),
  KEY `idx_codigo` (`codigo_reclamo`),
  KEY `idx_estado` (`estado`),
  KEY `idx_fecha` (`fecha_registro`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reclamos`
--

LOCK TABLES `reclamos` WRITE;
/*!40000 ALTER TABLE `reclamos` DISABLE KEYS */;
INSERT INTO `reclamos` (`id`, `codigo_reclamo`, `tipo_reclamo`, `fecha_incidente`, `fecha_registro`, `tipo_documento`, `numero_documento`, `nombres_apellidos`, `domicilio`, `departamento`, `provincia`, `distrito`, `telefono`, `email`, `descripcion_hechos`, `pedido_reclamo`, `monto_reclamado`, `tipo_bien`, `descripcion_bien`, `marca`, `modelo`, `numero_serie`, `tipo_comprobante`, `numero_comprobante`, `fecha_compra`, `monto_compra`, `estado`, `observaciones_internas`, `fecha_respuesta`, `respuesta_empresa`, `nombre_representante`, `cargo_representante`) VALUES (1,'REC-20251219-72A42A','queja','2025-02-15','2025-12-19 04:15:51','DNI','75375747','Martin','sedc',NULL,NULL,NULL,'936602622','martinserna021@gmail.com','fr','2',15.00,'producto',NULL,NULL,NULL,NULL,'ninguno',NULL,NULL,NULL,'registrado',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `reclamos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `seguimiento_reclamos`
--

DROP TABLE IF EXISTS `seguimiento_reclamos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `seguimiento_reclamos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reclamo_id` int(11) NOT NULL,
  `fecha_seguimiento` datetime DEFAULT current_timestamp(),
  `usuario_id` int(11) DEFAULT NULL,
  `accion` varchar(100) NOT NULL,
  `descripcion` text NOT NULL,
  `estado_anterior` varchar(50) DEFAULT NULL,
  `estado_nuevo` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usuario_id` (`usuario_id`),
  KEY `idx_reclamo` (`reclamo_id`),
  KEY `idx_fecha` (`fecha_seguimiento`),
  CONSTRAINT `seguimiento_reclamos_ibfk_1` FOREIGN KEY (`reclamo_id`) REFERENCES `reclamos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `seguimiento_reclamos_ibfk_2` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `seguimiento_reclamos`
--

LOCK TABLES `seguimiento_reclamos` WRITE;
/*!40000 ALTER TABLE `seguimiento_reclamos` DISABLE KEYS */;
INSERT INTO `seguimiento_reclamos` (`id`, `reclamo_id`, `fecha_seguimiento`, `usuario_id`, `accion`, `descripcion`, `estado_anterior`, `estado_nuevo`) VALUES (1,1,'2025-12-19 04:15:51',NULL,'Registro','Reclamo registrado en el sistema',NULL,NULL);
/*!40000 ALTER TABLE `seguimiento_reclamos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `usuarios`
--

DROP TABLE IF EXISTS `usuarios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `rol` enum('admin','cajero','almacenero') NOT NULL DEFAULT 'cajero',
  `fecha_registro` timestamp NULL DEFAULT current_timestamp(),
  `activo` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `usuarios`
--

LOCK TABLES `usuarios` WRITE;
/*!40000 ALTER TABLE `usuarios` DISABLE KEYS */;
INSERT INTO `usuarios` (`id`, `nombre`, `email`, `password`, `rol`, `fecha_registro`, `activo`) VALUES (1,'Administrador','admin@ferreteria.com','$2y$10$HC6ZSTgDtkaVX0/I6qbC9O0afpkTYK5VTtzhcx3YODzVT4VFAAIZ2','admin','2025-12-06 22:09:39',1),
(4,'Carlos Cajero','cajero@ferreteria.com','$2y$10$DUjTx2JfiHaKIOMZ3wh2tu27K/dZrXDkjXG4WwSZtd5t0BMLIHYtK','cajero','2025-12-14 19:12:56',1),
(5,'Ana Almacenera','almacen@ferreteria.com','ferreteria123','almacenero','2025-12-14 19:12:56',1),
(6,'Jesus Rodriguez','rodriguezjesas6@autonoma.edu.pe','$2y$10$4T1kFXoKAgmHq9SOhAF4v.1JRUBu8BPMFcc05fi.W3v1n..uxNwY6','admin','2025-12-15 03:05:16',1);
/*!40000 ALTER TABLE `usuarios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ventas`
--

DROP TABLE IF EXISTS `ventas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ventas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_usuario` int(11) NOT NULL DEFAULT 1,
  `fecha` timestamp NULL DEFAULT current_timestamp(),
  `total` decimal(10,2) NOT NULL,
  `tipo_documento` enum('boleta','factura') NOT NULL,
  `numero_documento` varchar(20) NOT NULL,
  `nombre_cliente` varchar(100) DEFAULT NULL,
  `tipo_documento_cliente` varchar(20) DEFAULT NULL,
  `numero_documento_cliente` varchar(20) DEFAULT NULL,
  `email_cliente` varchar(100) DEFAULT NULL,
  `telefono_cliente` varchar(20) DEFAULT NULL,
  `direccion_cliente` text DEFAULT NULL,
  `estado` enum('pendiente','completada','cancelada') DEFAULT 'pendiente',
  PRIMARY KEY (`id`),
  KEY `id_usuario` (`id_usuario`),
  CONSTRAINT `ventas_ibfk_1` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ventas`
--

LOCK TABLES `ventas` WRITE;
/*!40000 ALTER TABLE `ventas` DISABLE KEYS */;
INSERT INTO `ventas` (`id`, `id_usuario`, `fecha`, `total`, `tipo_documento`, `numero_documento`, `nombre_cliente`, `tipo_documento_cliente`, `numero_documento_cliente`, `email_cliente`, `telefono_cliente`, `direccion_cliente`, `estado`) VALUES (1,1,'2025-12-06 22:32:37',74.25,'boleta','B-510760',NULL,NULL,NULL,NULL,NULL,NULL,'pendiente'),
(2,1,'2025-12-06 23:10:31',290.25,'boleta','B-852874',NULL,NULL,NULL,NULL,NULL,NULL,'pendiente'),
(3,1,'2025-12-14 20:02:06',15.90,'boleta','B-20251214-821','martin','DNI','75375747','martinserna@gmail.com','936602622','villa','pendiente'),
(4,1,'2025-12-15 00:28:47',77.60,'boleta','B-20251215-833','Juan','DNI','75375747','martin.cs.1528@gmail.com','932123227','Aquí','pendiente'),
(5,1,'2025-12-15 12:47:26',45.80,'factura','F-20251215-681','Jull','RUC','10753757479','jull@gmail.com','978456123','Villa el Salvador','pendiente'),
(6,1,'2025-12-19 03:48:57',15.90,'boleta','B-20251219-229','MARTIN','DNI','75375747','MARTINSERNA021@GMAIL.COM','936602622','A','pendiente'),
(7,1,'2025-12-19 15:21:20',35.80,'boleta','B-20251219-806','Mario Apaza','DNI','70284351','jhnwarr@gmail.com','980444513','Lima','pendiente'),
(8,1,'2025-12-19 15:26:14',338.30,'factura','F-20251219-270','Mario Apaza Rodriguez','RUC','12345678912','jhnwarr_ingenieria@gmail.com','980444513','Lima','pendiente'),
(9,1,'2025-12-19 15:27:49',19.90,'boleta','B-20251219-655','Jesus Rodriguez','DNI','70284351','jhnwarr@gmail.com','980444513','Lima','pendiente'),
(10,1,'2025-12-20 06:17:23',15.90,'boleta','B-20251220-700','JUAN FRIDAZ','DNI','75375457','FRIDAAZ@ELZANGA.COM','987654321','aAQIUÍ','pendiente'),
(11,1,'2025-12-20 23:03:07',25.00,'boleta','B-20251220-274','mario apaza','DNI','72154789','jhnwarr@gmail.com','980555045','Sector 3, grupo 21, manzana D, lote 22','pendiente'),
(12,1,'2025-12-21 01:09:44',30.00,'boleta','B-20251221-040','JESUS FRIDAS CONDE','DNI','15915915','FRIDAAZ@ELZANGA.COM','922202622','FRIDAST@GMAIL.COM','pendiente'),
(13,1,'2025-12-21 19:45:02',30.00,'boleta','B-20251221-113','LADY','DNI','70908881','guillencastillolady2003@gmail.com','9072743066','MARTINC','pendiente');
/*!40000 ALTER TABLE `ventas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'monteroa_ferreteria'
--

--
-- Dumping routines for database 'monteroa_ferreteria'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2026-01-20  5:33:35
