<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Alerta VES</title>
    
    <!-- Librerías externas -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- CSS local -->
    <link rel="stylesheet" href="frontend/Assets/css/styles.css">
    
    <!-- Icono -->
    <link rel="icon" href="frontend/Assets/images/favicon.png">
</head>
<body>
    <!-- Contenedor para notificaciones -->
    <div id="notificaciones-container" class="notificaciones-container"></div>
    
    <!-- Notificación de emergencia-->
    <div id="notificacion-emergencia" class="notificacion-emergencia" style="display: none;">
        <div class="contenido">
            <div class="icono">
                <i class="fas fa-exclamation-triangle fa-3x"></i>
            </div>
            <div class="mensaje">
                <h3>¡EMERGENCIA!</h3>
                <p>Se ha activado el botón de pánico.</p>
            </div>
            <button class="btn btn-light" onclick="cerrarNotificacionEmergencia(this)">
                <i class="fas fa-times"></i>
            </button>
        </div>
    </div>

    <header>
        <div class="container header-content">
            <div class="logo">
                <i class="fas fa-bell"></i>
                <h1>Alerta VES</h1>
            </div>
        </div>
    </header>

    <main>
        <div class="container">
            <div class="dashboard">
                <!-- Botón de Pánico -->
                <div class="panic-button-container">
                    <button id="btnPanico" class="panic-button">
                        <i class="fas fa-exclamation-triangle"></i> BOTON DE PANICO
                    </button>
                    <div class="location-permission-notice">
                        <i class="fas fa-info-circle"></i>
                        Para usar el boton de panico, necesitas permitir el acceso a tu ubicacion
                    </div>
                </div>

                <!-- Report Section -->
                <section class="report-section">
                    <h2 class="section-title">
                        <i class="fas fa-exclamation-circle"></i>
                        Reportar Incidente
                    </h2>
                    
                    <form id="alertaForm" enctype="multipart/form-data">
                        <div class="form-group">
                            <label for="incident-type">Tipo de Incidente</label>
                            <select id="incident-type" name="tipo" required>
                                <option value="">Seleccione...</option>
                                <option value="robo">Robo</option>
                                <option value="accidente">Accidente</option>
                                <option value="incendio">Incendio</option>
                                <option value="violencia">Violencia</option>
                                <option value="otro">Otro</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="incident-title">Título</label>
                            <input type="text" id="incident-title" name="titulo" required placeholder="Breve descripción del incidente">
                        </div>
                        
                        <div class="form-group">
                            <label for="incident-description">Descripcion</label>
                            <textarea id="incident-description" name="descripcion" rows="4" required placeholder="Describa detalladamente lo sucedido"></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="incident-location">Ubicacion</label>
                            <div class="location-input-group">
                                <input type="text" id="incident-location" name="ubicacion" required readonly placeholder="Obtener ubicación actual">
                                <button type="button" id="btnUbicacion">
                                    <i class="fas fa-map-marker-alt"></i> Obtener Ubicacion
                                </button>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="incident-photo">Foto (opcional)</label>
                            <input type="file" id="incident-photo" name="foto" accept="image/*">
                        </div>
                        
                        <div class="form-group">
                            <label for="incident-priority">Prioridad</label>
                            <select id="incident-priority" name="prioridad">
                                <option value="baja">Baja</option>
                                <option value="media" selected>Media</option>
                                <option value="alta">Alta</option>
                            </select>
                        </div>
                        
                        <button type="submit" class="submit-btn">
                            <i class="fas fa-paper-plane"></i> Enviar Reporte
                        </button>
                    </form>
                    
                    <div id="map" class="map-container"></div>
                </section>

                <!-- Alertas Recientes -->
                <section class="recent-alerts">
                    <h2 class="section-title">
                        <i class="fas fa-bell"></i>
                        Alertas Recientes
                    </h2>
                    <div id="alerts-container" class="alerts-container">
                        <!-- Las alertas se cargarán dinámicamente -->
                        <div class="text-center">
                            <i class="fas fa-spinner fa-spin fa-2x"></i>
                            <p>Cargando alertas...</p>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </main>

    <!-- Scripts externos -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    
    <!-- Scripts locales -->
<script src="frontend/Assets/js/app.js"></script>
<script src="frontend/Assets/js/alerts.js"></script>
<script src="frontend/Assets/js/map.js"></script>
</body>
</html>