<?php
// Ejecutar todas las pruebas
header('Content-Type: text/html; charset=utf-8');

echo "<h1>🚀 Ejecutando Todas las Pruebas del Sistema</h1>";
echo "<p><em>Iniciando: " . date('d/m/Y H:i:s') . "</em></p>";

$tests = [
    'API' => 'test-api.php',
    'Base de Datos' => 'test-database.php',
    'Seguridad' => 'test-security.php',
    'Rendimiento' => 'test-performance.php'
];

foreach ($tests as $name => $file) {
    echo "<div style='border:2px solid #3498db; margin:20px 0; padding:15px;'>
        <h2>🧪 Ejecutando: $name</h2>";
    
    if (file_exists($file)) {
        include($file);
    } else {
        echo "<p class='error'>❌ Archivo de prueba no encontrado: $file</p>";
    }
    
    echo "</div>";
}

echo "<h2>🎉 Pruebas Completadas</h2>";
echo "<p><em>Finalizado: " . date('d/m/Y H:i:s') . "</em></p>";

echo "<div style='background:#2ecc71;color:white;padding:20px;margin-top:30px;'>
    <h3>✅ Sistema Listo para Producción</h3>
    <p>Si todas las pruebas pasaron, tu sistema está listo para:</p>
    <ol>
        <li>📱 Uso por la comunidad</li>
        <li>🔔 Recepción de alertas en tiempo real</li>
        <li>🗺️ Visualización en mapa</li>
        <li>🛡️ Operación segura</li>
    </ol>
    <p><a href='https://martin.monteroampsoluciones.com/' style='color:white;font-weight:bold;'>👉 Ir al Sistema de Alertas</a></p>
</div>";
?>