<?php
// Configuración de la API

// Configuración de base de datos
define('DB_HOST', 'localhost');
define('DB_USER', 'monteroa_alerta_ves');
define('DB_PASS', 'AlertaVES2025!');
define('DB_NAME_ALERTAS', 'monteroa_alerta_ves');
define('DB_NAME_NOTIFICACIONES', 'monteroa_notificaciones_ves');

// Configuración de la aplicación
define('APP_TIMEZONE', 'America/Lima');
define('APP_URL', 'https://martin.monteroampsoluciones.com');
define('API_VERSION', '1.0');

// Headers para JSON
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

// ================= CONFIGURACIÓN DE ZONA HORARIA =================
// Forzar zona horaria de Perú
if (function_exists('date_default_timezone_set')) {
    date_default_timezone_set('America/Lima');
    ini_set('date.timezone', 'America/Lima');
}

// También para MySQL en las conexiones
function connectAlertasDB() {
    try {
        $conn = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME_ALERTAS . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
        
        // Ajustar zona horaria para MySQL también
        $conn->exec("SET time_zone = '-05:00'");
        
        return $conn;
    } catch (PDOException $e) {
        error_log("Error BD Alertas: " . $e->getMessage());
        return null;
    }
}

// Lo mismo para la otra conexión
function connectNotificacionesDB() {
    try {
        $conn = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME_NOTIFICACIONES . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
        
        // Ajustar zona horaria para MySQL
        $conn->exec("SET time_zone = '-05:00'");
        
        return $conn;
    } catch (PDOException $e) {
        error_log("Error BD Notificaciones: " . $e->getMessage());
        return null;
    }
}

// Función para respuestas JSON
function jsonResponse($success, $message = '', $data = null, $statusCode = 200) {
    http_response_code($statusCode);
    
    $response = [
        'success' => $success,
        'message' => $message,
        'timestamp' => date('Y-m-d H:i:s'),
        'data' => $data
    ];
    
    echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

// Función para conectar a BD de alertas
function connectAlertasDB() {
    try {
        $conn = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME_ALERTAS . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
        return $conn;
    } catch (PDOException $e) {
        error_log("Error BD Alertas: " . $e->getMessage());
        return null;
    }
}

// Función para conectar a BD de notificaciones
function connectNotificacionesDB() {
    try {
        $conn = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME_NOTIFICACIONES . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
        return $conn;
    } catch (PDOException $e) {
        error_log("Error BD Notificaciones: " . $e->getMessage());
        return null;
    }
}

// Función para log
function logAction($action, $details = '') {
    $logFile = __DIR__ . '/../logs/api.log';
    $timestamp = date('Y-m-d H:i:s');
    $logEntry = "[$timestamp] $action - $details\n";
    
    if (!file_exists(dirname($logFile))) {
        mkdir(dirname($logFile), 0755, true);
    }
    
    file_put_contents($logFile, $logEntry, FILE_APPEND);
}
?>