<?php
class Database {
    private $connections = [];
    private static $instance = null;

    public function __construct() {
        // 
        $this->connections[] = $this->createConnection(
            'localhost',         
            'monteroa_alerta_ves', 
            'monteroa_alerta_ves', 
            'AlertaVES2025!'      
        );
    }

    private function createConnection($host, $dbname, $username, $password) {
        try {
            $conn = new PDO(
                "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
                $username,
                $password,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
            return $conn;
        } catch(PDOException $e) {
            error_log("Error de conexión BD en ms-alertas: " . $e->getMessage());
            throw new Exception("Error de conexión con la base de datos de alertas");
        }
    }

    public static function getInstance() {
        if (self::$instance == null) {
            self::$instance = new Database();
        }
        return self::$instance;
    }

    public function connect() {
        // Retorna la primera conexión disponible
        foreach ($this->connections as $conn) {
            try {
                $conn->query("SELECT 1");
                return $conn;
            } catch (PDOException $e) {
                continue;
            }
        }
        throw new Exception("No hay conexiones disponibles");
    }

    public function getConnection($key) {
        // Como solo hay una conexión, siempre retornamos la primera
        return $this->connections[0];
    }
}
?>