<?php
class FileCache {
    private $cacheDir;
    private static $instance = null;

    public function __construct() {
        $this->cacheDir = __DIR__ . '/../../cache';
        if (!file_exists($this->cacheDir)) {
            mkdir($this->cacheDir, 0755, true);
        }
    }

    public static function getInstance() {
        if (self::$instance == null) {
            self::$instance = new FileCache();
        }
        return self::$instance;
    }

    public function get($key) {
        $file = $this->cacheDir . '/' . md5($key) . '.cache';
        if (!file_exists($file)) {
            return false;
        }

        $data = file_get_contents($file);
        $data = unserialize($data);

        if ($data['ttl'] < time()) {
            unlink($file);
            return false;
        }

        return $data['value'];
    }

    public function set($key, $data, $ttl = 3600) {
        $file = $this->cacheDir . '/' . md5($key) . '.cache';
        $data = [
            'value' => $data,
            'ttl' => time() + $ttl
        ];
        file_put_contents($file, serialize($data));
        return true;
    }

    public function delete($key) {
        $file = $this->cacheDir . '/' . md5($key) . '.cache';
        if (file_exists($file)) {
            unlink($file);
        }
        return true;
    }

    public function deletePattern($pattern) {
        $files = glob($this->cacheDir . '/*.cache');
        foreach ($files as $file) {
            unlink($file);
        }
        return true;
    }
}
?>