<?php
session_start();
if (!isset($_SESSION['usuario']) || !in_array($_SESSION['usuario']['rol'], ['admin', 'almacenero'])) {
    header('Location: ../../login.php');
    exit;
}

include '../../config/db.php';
include '../../includes/header.php';

// Obtener productos con stock bajo
$stmt = $pdo->query("SELECT * FROM productos WHERE stock <= stock_minimo ORDER BY stock ASC");
$stock_bajo = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Obtener todos los productos
$stmt = $pdo->query("SELECT * FROM productos ORDER BY nombre");
$productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar para almacenero -->
        <nav class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse">
            <div class="position-sticky pt-3">
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link active" href="index.php">
                            <i class="bi bi-speedometer2 me-2"></i> Panel Almacén
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="entradas.php">
                            <i class="bi bi-box-arrow-in-down me-2"></i> Entradas
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="salidas.php">
                            <i class="bi bi-box-arrow-up me-2"></i> Salidas
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="ajustes.php">
                            <i class="bi bi-sliders me-2"></i> Ajustes
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="reportes.php">
                            <i class="bi bi-graph-up me-2"></i> Reportes
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-danger" href="../../logout.php">
                            <i class="bi bi-box-arrow-right me-2"></i> Cerrar Sesión
                        </a>
                    </li>
                </ul>
                
                <!-- Alertas de stock -->
                <div class="mt-4 p-3 bg-white border rounded">
                    <h6 class="mb-3">Alertas Stock</h6>
                    <?php if (!empty($stock_bajo)): ?>
                        <div class="alert alert-danger py-2 mb-2">
                            <i class="bi bi-exclamation-triangle me-1"></i>
                            <strong><?php echo count($stock_bajo); ?> productos</strong>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-success py-2">
                            <i class="bi bi-check-circle me-1"></i>
                            Stock normal
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </nav>

        <!-- Main content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Gestión de Inventario</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <span class="badge bg-primary me-3">Almacenero: <?php echo $_SESSION['usuario']['nombre']; ?></span>
                    <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalEntrada">
                        <i class="bi bi-plus-circle me-1"></i> Nueva Entrada
                    </button>
                </div>
            </div>

            <!-- Alertas de stock bajo -->
            <?php if (!empty($stock_bajo)): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <h5 class="alert-heading">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i>
                    ¡Alerta de Stock Bajo!
                </h5>
                <p>Hay <?php echo count($stock_bajo); ?> productos que requieren reabastecimiento inmediato.</p>
                <hr>
                <div class="row">
                    <?php foreach (array_slice($stock_bajo, 0, 3) as $producto): ?>
                    <div class="col-md-4">
                        <div class="d-flex align-items-center mb-2">
                            <img src="../../assets/img/<?php echo $producto['imagen']; ?>" 
                                 width="40" height="40" class="rounded me-2">
                            <div>
                                <strong><?php echo $producto['nombre']; ?></strong><br>
                                <small>Stock: <?php echo $producto['stock']; ?> | Mínimo: <?php echo $producto['stock_minimo']; ?></small>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php if (count($stock_bajo) > 3): ?>
                    <p class="mb-0"><small>+<?php echo count($stock_bajo) - 3; ?> productos más...</small></p>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <!-- Inventario completo -->
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Inventario de Productos</h5>
                        <div class="input-group" style="width: 300px;">
                            <input type="text" class="form-control" placeholder="Buscar producto..." id="buscadorInventario">
                            <button class="btn btn-outline-secondary" type="button">
                                <i class="bi bi-search"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover" id="tablaInventario">
                            <thead>
                                <tr>
                                    <th>Imagen</th>
                                    <th>Producto</th>
                                    <th>Categoría</th>
                                    <th>Stock Actual</th>
                                    <th>Stock Mínimo</th>
                                    <th>Precio</th>
                                    <th>Estado</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($productos as $producto): 
                                    $porcentaje_stock = $producto['stock_minimo'] > 0 ? 
                                        ($producto['stock'] / $producto['stock_minimo']) * 100 : 100;
                                    $estado_color = $porcentaje_stock > 150 ? 'success' : 
                                                  ($porcentaje_stock > 100 ? 'warning' : 'danger');
                                ?>
                                <tr>
                                    <td>
                                        <img src="../../assets/img/<?php echo $producto['imagen']; ?>" 
                                             width="40" height="40" class="img-thumbnail">
                                    </td>
                                    <td>
                                        <strong><?php echo $producto['nombre']; ?></strong><br>
                                        <small class="text-muted"><?php echo substr($producto['descripcion'], 0, 30); ?>...</small>
                                    </td>
                                    <td><?php echo $producto['categoria'] ?? 'General'; ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $estado_color; ?>">
                                            <?php echo $producto['stock']; ?>
                                        </span>
                                    </td>
                                    <td><?php echo $producto['stock_minimo']; ?></td>
                                    <td>S/<?php echo number_format($producto['precio'], 2); ?></td>
                                    <td>
                                        <?php if ($producto['stock'] == 0): ?>
                                            <span class="badge bg-danger">Agotado</span>
                                        <?php elseif ($producto['stock'] <= $producto['stock_minimo']): ?>
                                            <span class="badge bg-warning">Bajo</span>
                                        <?php elseif ($producto['stock'] <= $producto['stock_minimo'] * 2): ?>
                                            <span class="badge bg-info">Normal</span>
                                        <?php else: ?>
                                            <span class="badge bg-success">Alto</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-primary" 
                                                    data-bs-toggle="modal" 
                                                    data-bs-target="#modalAjustarStock"
                                                    data-id="<?php echo $producto['id']; ?>"
                                                    data-nombre="<?php echo $producto['nombre']; ?>"
                                                    data-stock="<?php echo $producto['stock']; ?>">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <a href="detalle.php?id=<?php echo $producto['id']; ?>" 
                                               class="btn btn-outline-info">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Resumen por categorías -->
            <div class="row mt-4">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h6>Stock por Categoría</h6>
                        </div>
                        <div class="card-body">
                            <canvas id="graficoCategorias" height="200"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h6>Productos Próximos a Agotarse</h6>
                        </div>
                        <div class="card-body">
                            <div class="list-group">
                                <?php 
                                $stmt = $pdo->query("SELECT * FROM productos 
                                                    WHERE stock > 0 AND stock <= stock_minimo * 1.5
                                                    ORDER BY stock ASC 
                                                    LIMIT 5");
                                $proximos_agotar = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                ?>
                                
                                <?php foreach ($proximos_agotar as $producto): 
                                    $porcentaje = ($producto['stock'] / $producto['stock_minimo']) * 100;
                                ?>
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong><?php echo $producto['nombre']; ?></strong><br>
                                            <small class="text-muted">Stock: <?php echo $producto['stock']; ?></small>
                                        </div>
                                        <div class="text-end">
                                            <div class="progress" style="width: 100px; height: 10px;">
                                                <div class="progress-bar bg-warning" 
                                                     role="progressbar" 
                                                     style="width: <?php echo min($porcentaje, 100); ?>%">
                                                </div>
                                            </div>
                                            <small><?php echo round($porcentaje); ?>% del mínimo</small>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                                
                                <?php if (empty($proximos_agotar)): ?>
                                <div class="text-center py-3 text-muted">
                                    <i class="bi bi-check-circle display-4"></i>
                                    <p class="mt-2">¡Todo bajo control!</p>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<!-- Modal Entrada de Stock -->
<div class="modal fade" id="modalEntrada" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Registrar Entrada de Stock</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="post" action="procesar_entrada.php">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Producto</label>
                        <select class="form-select" name="id_producto" required>
                            <option value="">Seleccionar producto...</option>
                            <?php foreach ($productos as $producto): ?>
                            <option value="<?php echo $producto['id']; ?>">
                                <?php echo $producto['nombre']; ?> (Stock: <?php echo $producto['stock']; ?>)
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Cantidad</label>
                        <input type="number" class="form-control" name="cantidad" min="1" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Proveedor</label>
                        <input type="text" class="form-control" name="proveedor">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Número de Factura/Lote</label>
                        <input type="text" class="form-control" name="numero_lote">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Observaciones</label>
                        <textarea class="form-control" name="observaciones" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Registrar Entrada</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Ajustar Stock -->
<div class="modal fade" id="modalAjustarStock" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Ajustar Stock</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="post" action="ajustar_stock.php">
                <div class="modal-body">
                    <input type="hidden" name="id_producto" id="ajuste_id_producto">
                    <p>Producto: <strong id="ajuste_nombre"></strong></p>
                    <p>Stock actual: <strong id="ajuste_stock"></strong></p>
                    
                    <div class="mb-3">
                        <label class="form-label">Tipo de Ajuste</label>
                        <select class="form-select" name="tipo_ajuste" id="tipo_ajuste">
                            <option value="entrada">Entrada (Aumentar stock)</option>
                            <option value="salida">Salida (Disminuir stock)</option>
                            <option value="correccion">Corrección (Establecer nuevo valor)</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Cantidad</label>
                        <input type="number" class="form-control" name="cantidad" min="1" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Motivo</label>
                        <select class="form-select" name="motivo">
                            <option value="compra">Compra a proveedor</option>
                            <option value="devolucion">Devolución de cliente</option>
                            <option value="perdida">Pérdida o daño</option>
                            <option value="conteo">Diferencia en conteo</option>
                            <option value="otros">Otros</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Observaciones</label>
                        <textarea class="form-control" name="observaciones" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Aplicar Ajuste</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Gráfico de categorías
const ctxCategorias = document.getElementById('graficoCategorias').getContext('2d');
const graficoCategorias = new Chart(ctxCategorias, {
    type: 'bar',
    data: {
        labels: ['Herramientas', 'Electricidad', 'Fontanería', 'Pintura', 'Fijación'],
        datasets: [{
            label: 'Stock por Categoría',
            data: [45, 32, 28, 19, 41],
            backgroundColor: [
                '#0d6efd',
                '#198754',
                '#ffc107',
                '#dc3545',
                '#6f42c1'
            ]
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Buscador de inventario
$('#buscadorInventario').on('keyup', function() {
    const value = $(this).val().toLowerCase();
    $('#tablaInventario tbody tr').filter(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
    });
});

// Modal para ajustar stock
$('#modalAjustarStock').on('show.bs.modal', function(event) {
    const button = $(event.relatedTarget);
    const id = button.data('id');
    const nombre = button.data('nombre');
    const stock = button.data('stock');
    
    const modal = $(this);
    modal.find('#ajuste_id_producto').val(id);
    modal.find('#ajuste_nombre').text(nombre);
    modal.find('#ajuste_stock').text(stock);
});
</script>

<?php include '../../includes/footer.php'; ?>