<?php
// Pruebas de Rendimiento
echo "<h2>⚡ Pruebas de Rendimiento</h2>";

// 1. Tiempos de respuesta API
echo "<h3>1. ⏱️ Tiempos de Respuesta API</h3>";

function test_api_response($url, $name) {
    $start = microtime(true);
    $context = stream_context_create([
        'ssl' => ['verify_peer' => false],
        'http' => ['header' => "Accept: application/json\r\n"]
    ]);
    
    $response = @file_get_contents($url, false, $context);
    $time = round((microtime(true) - $start) * 1000, 2);
    
    $status = $response !== false ? '✅' : '❌';
    
    return "<p>$status $name: $time ms - <a href='$url' target='_blank'>Probar</a></p>";
}

echo test_api_response('https://martin.monteroampsoluciones.com/backend/microservices/alertas/', 'API Raíz');
echo test_api_response('https://martin.monteroampsoluciones.com/backend/microservices/alertas/recientes', 'API Recientes');
echo test_api_response('https://martin.monteroampsoluciones.com/', 'Frontend Principal');

// 2. Uso de memoria
echo "<h3>2. 💾 Uso de Memoria</h3>";

$memory_start = memory_get_usage();
$conn = new PDO("mysql:host=localhost;dbname=monteroa_alerta_ves", 
               "monteroa_alerta_ves", 
               "AlertaVES2025!");
$conn->query("SELECT * FROM alertas LIMIT 50");
$memory_used = memory_get_usage() - $memory_start;

echo "<p>Memoria usada para consulta 50 alertas: " . round($memory_used / 1024, 2) . " KB</p>";

if ($memory_used < 1024 * 1024) { // Menos de 1MB
    echo "<p class='success'>✅ Uso de memoria eficiente</p>";
} else {
    echo "<p class='warning'>⚠️ Considera optimizar uso de memoria</p>";
}

// 3. Prueba de carga concurrente simulada
echo "<h3>3. 🔄 Prueba de Carga Simulada</h3>";

echo "<p>Simulando 10 solicitudes rápidas a la API:</p>";
$times = [];
for ($i = 0; $i < 10; $i++) {
    $start = microtime(true);
    @file_get_contents('https://martin.monteroampsoluciones.com/backend/microservices/alertas/', 
                      false, 
                      stream_context_create(['ssl' => ['verify_peer' => false]]));
    $times[] = microtime(true) - $start;
    usleep(100000); // 100ms entre solicitudes
}

$avg = array_sum($times) / count($times) * 1000;
$max = max($times) * 1000;
$min = min($times) * 1000;

echo "<p>Promedio: " . round($avg, 2) . " ms</p>";
echo "<p>Máximo: " . round($max, 2) . " ms</p>";
echo "<p>Mínimo: " . round($min, 2) . " ms</p>";

if ($avg < 500) {
    echo "<p class='success'>✅ Excelente rendimiento bajo carga</p>";
} elseif ($avg < 1000) {
    echo "<p class='warning'>⚠️ Rendimiento aceptable</p>";
} else {
    echo "<p class='error'>❌ Rendimiento bajo carga necesita mejora</p>";
}
?>