<?php
class AlertasController {
    private $model;
    
    public function __construct($db) {
        $this->model = new AlertasModel($db);
        // Crear tabla si no existe
        $this->model->createTableIfNotExists();
    }
    
    public function getAlertasRecientes() {
        $alertas = $this->model->getAlertasRecientes(10);
        
        // Datos de prueba si la tabla está vacía
        if(empty($alertas)) {
            $alertas = [
                [
                    'id' => 1,
                    'tipo' => 'robo',
                    'titulo' => 'Robo en Calle Principal',
                    'descripcion' => 'Se reportó un robo a mano armada',
                    'ubicacion' => 'Calle Principal 123',
                    'prioridad' => 'alta',
                    'fecha_creacion' => date('Y-m-d H:i:s')
                ],
                [
                    'id' => 2,
                    'tipo' => 'accidente',
                    'titulo' => 'Accidente vehicular',
                    'descripcion' => 'Choque entre dos automóviles',
                    'ubicacion' => 'Avenida Central 456',
                    'prioridad' => 'media',
                    'fecha_creacion' => date('Y-m-d H:i:s', strtotime('-1 hour'))
                ]
            ];
        }
        
        echo json_encode([
            'success' => true,
            'data' => $alertas
        ]);
    }
    
    public function createAlerta($data) {
        // Verificar si es alerta de pánico
        if(isset($data['tipo']) && $data['tipo'] === 'panico') {
            $result = $this->model->createAlertaPanico(
                $data['latitud'] ?? 0,
                $data['longitud'] ?? 0
            );
        } else {
            $result = $this->model->createAlerta($data);
        }
        
        echo json_encode($result);
    }
}
?>