<?php
require_once __DIR__ . '/../config/database.php';

class Notificacion {
    private $conn;
    private $table_name = "notificaciones";
    
    public $id;
    public $tipo;
    public $destinatario;
    public $mensaje;
    public $estado;
    public $fecha_envio;
    public $fecha_creacion;
    
    public function __construct() {
        try {
            $database = Database::getInstance();
            $this->conn = $database->connect();
        } catch (Exception $e) {
            error_log("Error en Notificacion constructor: " . $e->getMessage());
            throw $e;
        }
    }
    
    public function create() {
        try {
            $query = "INSERT INTO " . $this->table_name . "
                      SET tipo=:tipo, destinatario=:destinatario, 
                          mensaje=:mensaje, estado='pendiente'";
            
            $stmt = $this->conn->prepare($query);
            
            // Limpiar datos
            $this->tipo = htmlspecialchars(strip_tags($this->tipo));
            $this->destinatario = htmlspecialchars(strip_tags($this->destinatario));
            $this->mensaje = htmlspecialchars(strip_tags($this->mensaje));
            
            // Bind values
            $stmt->bindParam(":tipo", $this->tipo);
            $stmt->bindParam(":destinatario", $this->destinatario);
            $stmt->bindParam(":mensaje", $this->mensaje);
            
            if($stmt->execute()) {
                return true;
            }
            
            $error = $stmt->errorInfo();
            error_log("Error SQL en Notificacion::create: " . print_r($error, true));
            return false;
        } catch (Exception $e) {
            error_log("Excepción en Notificacion::create: " . $e->getMessage());
            return false;
        }
    }
    
    public function read() {
        try {
            $query = "SELECT * FROM " . $this->table_name . " 
                      ORDER BY fecha_creacion DESC LIMIT 50";
            
            $stmt = $this->conn->prepare($query);
            $stmt->execute();
            return $stmt;
        } catch (Exception $e) {
            error_log("Error en Notificacion::read: " . $e->getMessage());
            throw $e;
        }
    }
    
    public function markAsSent($id) {
        try {
            $query = "UPDATE " . $this->table_name . " 
                      SET estado = 'enviado', fecha_envio = NOW() 
                      WHERE id = :id";
            
            $stmt = $this->conn->prepare($query);
            $stmt->bindParam(':id', $id);
            
            return $stmt->execute();
        } catch (Exception $e) {
            error_log("Error en Notificacion::markAsSent: " . $e->getMessage());
            return false;
        }
    }
}
?>